// Touch.h ramin.jafarpour@hotmail.com
// Header File for Resistive Touch Screen 


#ifndef touch_INCLUDED_
#define touch_INCLUDED_

#define min_x	225	
#define max_x	770
#define min_y	270	
#define max_y	885

#define x_range (max_x - min_x)
#define y_range (max_y - min_y)

#include "adc.h"

int touch(int *x,int *y){
	int a,b;
	/*  
	X+  PB.27
    y+  PB.28
    X-  PB.29
    Y-  PB.30   
	*/

	config_adc(0x04);
	AT91F_PIO_CfgOutput(AT91C_BASE_PIOB, AT91C_PIO_PB28 | AT91C_PIO_PB30);
	AT91F_PIO_CfgInput(AT91C_BASE_PIOB, AT91C_PIO_PB27 | AT91C_PIO_PB29);
	AT91F_PIO_SetOutput( AT91C_BASE_PIOB,AT91C_PIO_PB30);
	AT91F_PIO_ClearOutput( AT91C_BASE_PIOB,AT91C_PIO_PB28);   
	start_adc();
	b = read_adc(2);
	delay_us(100);

	config_adc(0x02);
	AT91F_PIO_CfgOutput(AT91C_BASE_PIOB, AT91C_PIO_PB27 | AT91C_PIO_PB29);
	AT91F_PIO_CfgInput(AT91C_BASE_PIOB, AT91C_PIO_PB28 | AT91C_PIO_PB30);
	AT91F_PIO_SetOutput( AT91C_BASE_PIOB,AT91C_PIO_PB29);
	AT91F_PIO_ClearOutput( AT91C_BASE_PIOB,AT91C_PIO_PB27);  
	start_adc();
	a = read_adc(1);
		
	if (b<max_y+10) *y = b-min_y;
	else b=0;
	if(a<max_x+10)  *x = a-min_x;
	else a=0;

	if ((a!=0)&&(b!=0))return 1;
	else return 0;
}


#endif
